/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.plan;

import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceActivityVisitor;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.util.IdentityHashSet;
import java.util.Collections;
import java.util.Set;

public class CumulativeWorkplaceActivity
extends WorkplaceActivity {
    private final String type;
    private final String cumulationType;
    private double consumption = 0.0;
    private final Set<ActionActivity> actionActivities;

    public CumulativeWorkplaceActivity(long start, long end, String type, String cumulationType, Workplace workplace) {
        super(start, end, workplace);
        this.type = type;
        this.cumulationType = cumulationType;
        this.actionActivities = new IdentityHashSet<ActionActivity>();
    }

    public CumulativeWorkplaceActivity(CumulativeWorkplaceActivity other) {
        super(other.getStart(), other.getEnd(), other.getWorkplace());
        this.type = other.getType();
        this.cumulationType = other.getCumulationType();
        this.consumption = other.getConsumption();
        IdentityHashSet<ActionActivity> newAA = new IdentityHashSet<ActionActivity>(other.actionActivities.size());
        for (ActionActivity aa : other.actionActivities) {
            newAA.add((ActionActivity)aa.duplicate());
        }
        this.actionActivities = newAA;
    }

    @Override
    public Activity duplicate() {
        return new CumulativeWorkplaceActivity(this);
    }

    public Set<ActionActivity> getActionActivities() {
        return Collections.unmodifiableSet(this.actionActivities);
    }

    public double getTotalQty() {
        double res = 0.0;
        for (ActionActivity aa : this.getActionActivities()) {
            res += aa.getQty();
        }
        return res;
    }

    public void addActionActivity(ActionActivity activity) {
        if (activity.getWorkplace() != this.getWorkplace()) {
            throw new IllegalArgumentException(activity + " doesn't lay on the same workplace as " + this);
        }
        if (activity.getStart() != this.getStart() || activity.getEnd() != this.getEnd()) {
            throw new IllegalArgumentException(activity + " doesn't match the interval [" + this.getStart() + "," + this.getEnd() + "]");
        }
        CumulativeAction ca = (CumulativeAction)activity.getAction();
        if (!this.cumulationType.equals(ca.getCumulationType())) {
            throw new IllegalArgumentException(activity + " is of the different cumulationType: " + ca.getCumulationType() + " != " + this.cumulationType);
        }
        this.actionActivities.add(activity);
        this.updateConsumption();
    }

    public void removeActionActivity(ActionActivity activity) {
        this.actionActivities.remove(activity);
        this.updateConsumption();
    }

    public double getActivityConsumption(ActionActivity activity) {
        if (activity.getStart() != this.getStart() || activity.getEnd() != this.getEnd()) {
            throw new IllegalArgumentException(activity + " doesn't match the interval [" + this.getStart() + "," + this.getEnd() + "]");
        }
        CumulativeAction ca = (CumulativeAction)activity.getAction();
        if (!this.cumulationType.equals(ca.getCumulationType())) {
            throw new IllegalArgumentException(activity + " is of the different canBeTogether: " + ca.getCumulationType() + " != " + this.cumulationType);
        }
        return 1.0 / ca.getFill() * activity.getQty();
    }

    public void updateConsumption() {
        double updatedConsumption = 0.0;
        for (ActionActivity activity : this.actionActivities) {
            updatedConsumption += this.getActivityConsumption(activity);
        }
        this.consumption = updatedConsumption;
    }

    public double getConsumption() {
        return this.consumption;
    }

    public double getRemainingCapacity() {
        return 1.0 - this.consumption;
    }

    public double getRemainingCapacity(CumulativeAction ca) {
        double qty = this.getRemainingCapacity() * ca.getFill();
        if (ca.getFill() != ca.getMaxFill()) {
            for (ActionActivity aa : this.actionActivities) {
                if (aa.getAction() != ca) continue;
                qty -= aa.getQty();
            }
            qty = Math.min(qty, ca.getMaxFill());
            qty = Math.max(qty, 0.0);
        }
        return ca.roundQtyWrtGranularityDown(qty);
    }

    public String getType() {
        return this.type;
    }

    public String getCumulationType() {
        return this.cumulationType;
    }

    @Override
    public void setStart(long start) {
        throw new IllegalStateException("Cannot change length of CumulativeWorkplaceActivity.");
    }

    @Override
    public void setStartEnd(long start, long end) {
        long duration = this.getEnd() - this.getStart();
        if (duration != end - start) {
            throw new IllegalStateException("Cannot change length of CumulativeWorkplaceActivity.");
        }
        super.setStartEnd(start, end);
        for (ActionActivity aa : this.getActionActivities()) {
            aa.setStartEndFromCwa(start, end);
        }
    }

    @Override
    public void setEnd(long end) {
        throw new IllegalStateException("Cannot change length of CumulativeWorkplaceActivity.");
    }

    @Override
    void accept(WorkplaceActivityVisitor visitor) {
        visitor.visit(this);
    }
}

